
public class Steuerung
{

    private Sudoku sudoku;
    private static final String VERSION = "Version 1.3";

    public Benutzerschnittstelle benutzer;
    public Steuerung()
    {
        sudoku = new Sudoku();
        benutzer = new Benutzerschnittstelle(this, sudoku);
        spielablauf();
    }

    public void spielablauf()
    {
        boolean beendet = false;
        while (! beendet)
        {

        }
    }

    public boolean spielIstGewonnen()
    {
        boolean richtig = testeObSudokuKorrektIst();
        boolean alleZahlenAusgefuellt = testeObAlleZahlenAusgefuelltSind();
        return (richtig && alleZahlenAusgefuellt);
    }

    public void formation1()
    {
        sudoku.initialisierenFeld1();
        benutzer.setzeSudoku(sudoku);
    }

    public void formation2()
    {
        sudoku.initialisierenFeld2();
        benutzer.setzeSudoku(sudoku);
    }

    public void formation3()
    {
        sudoku.initialisierenFeld3();
        benutzer.setzeSudoku(sudoku);
    }

    public String gibVersion()
    {
        return VERSION;
    }

    public int getZahlFeld (int pPositionX, int pPositionY)
    {
        return sudoku.gibZahl(pPositionX, pPositionY);
    }

    public void setzteZahl(int pPositionX, int pPositionY, int pWert)
    {
        sudoku.setzeZahl(pPositionX, pPositionY, pWert);
    }

    public boolean testeObAlleZahlenAusgefuelltSind()
    {
        boolean bisherKorrekt = true;

        for (int y = 0; y < sudoku.gibSeitenLaenge(); y++)
        {
            for (int x = 0; x < sudoku.gibSeitenLaenge(); x++)
            {
                if (bisherKorrekt == true)
                {
                    if (sudoku.gibZahl(x, y) <= 0 || sudoku.gibZahl(x, y) > 9)
                    {
                       bisherKorrekt = false; 
                    }
                }
                
            }
        }
        
        return bisherKorrekt;
    }

    public boolean testeObSudokuKorrektIst()
    {
        boolean bisherKorrekt = true;

        for (int y = 0; y < sudoku.gibSeitenLaenge(); y++)
        {
            Feld felderReihe [] = new Feld [sudoku.gibSeitenLaenge()];
            for (int x = 0; x < sudoku.gibSeitenLaenge(); x++)
            {
                felderReihe [x] = sudoku.gibFeld (x, y); 
            }

            if (bisherKorrekt == true)
            {
                bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
            }
        }

        for (int x = 0; x < sudoku.gibSeitenLaenge(); x++)
        {
            Feld felderReihe [] = new Feld [sudoku.gibSeitenLaenge()];
            for (int y = 0; y < sudoku.gibSeitenLaenge(); y++)
            {
                felderReihe [y] = sudoku.gibFeld (x, y); 
            }

            if (bisherKorrekt == true)
            {
                bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
            }
        }

        Feld felderReihe [] = new Feld [sudoku.gibSeitenLaenge()]; 
        int i = 0;

        for (int x = 0; x < sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 0; y < sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 3; x < 3 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 0; y < sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 6; x < 6 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 0; y < sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 0; x < sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 3; y < 3 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 3; x < 3 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 3; y < 3 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 6; x < 6 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 3; y < 3 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()]; 
        i = 0;

        for (int x = 0; x < sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 6; y < 6 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()];
        i = 0;

        for (int x = 3; x < 3 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 6; y < 6 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        felderReihe = new Feld [sudoku.gibSeitenLaenge()];
        i = 0;

        for (int x = 6; x < 6 + sudoku.gibSeitenLaenge() / 3; x ++)
        {

            for (int y = 6; y < 6 + sudoku.gibSeitenLaenge() / 3; y++)
            {
                felderReihe [i] = sudoku.gibFeld (x, y); 

                i ++;
            }
        }

        if (bisherKorrekt == true)
        {
            bisherKorrekt = testeAufZahlenVon1Bis9 (felderReihe);
        }

        return bisherKorrekt;
    }

    /**
     * testet wie viele zahlen in der zeile, spalte sind. gibt true zurück, wenn nicht mehr als 1
     * gleiche da ist
     */
    private boolean testeAufZahlenVon1Bis9 (Feld [] pN)
    {
        boolean istKorrekt = true;
        int [] zahlen = new int [9];
        if (pN.length <= 9)
        {
            for (int i = 0; i < pN.length; i++)
            {
                if (pN [i].getZahl() > 0 && pN [i].getZahl() <= 9)
                {
                    zahlen [pN [i].getZahl() - 1] += 1; 
                }
            }

            for (int i = 0; i < pN.length; i++)
            {
                if (zahlen [i] > 1)
                {
                    istKorrekt = false;
                }
            }

        }
        else
        {
            istKorrekt = false;
            System.out.println("Fehler Arr zu groß");
        }
        return istKorrekt;
    }

    public boolean istLoesbar()
    {
        boolean tmp = true;

        int [] zaehler = new int [81];
        for (int d = 0; d < zaehler.length; d++)
        {
            zaehler [d] = 1;
        }

        int index = 0;

        for (int x = 0; x < sudoku.gibSeitenLaenge(); x ++)
        {

            for (int y = 0; y < sudoku.gibSeitenLaenge(); y++)
            {
                if (sudoku.veraenderbar(x, y))
                {
                    sudoku.setzeZahl(x, y, zaehler [index]);
                }
                index ++;
            }
        }

        return tmp;
    }

}

